
; Tape leader 1.0
; maj du 13/03/2022

; Routine d'affichage encore bricolee, uniquement du mode graphique

; La routine principale appelle les vecteurs habituels d'une musique Soundtrakker 128
; Etrangement, le fait de redefinir des caracteres pose de serieux problemes techniques.
; Une case memoire est ecrasee (&863B), pas de bol, c'est dans la zone d'initialisation des
; musiques Sountrakker 128 (toutes implantees en &8000 pour la compilation).

; Pour eviter des comportements etranges de l'EF9345, la redefinition des caracteres, initialement
; faite sous Basic, est passee dans une routine en assembleur qui detourne le RST&38.
; Le resultat n'est pas forcement totalement satisfaisant, car en fonction du nombre de HALT qu'on
; ajoute dans la routine, on obtient des bugs (pas super logique).

; Enfin, bon, vu le faible nombre de personnes qui profiteront de ce bout de code, je ne vais pas
; y passer non plus des annees. Le VG 5000 garde encore une partie de ses mysteres donc...


ORG &6600
NOLIST

WRITE "LEADE2.BIN"

vector_init_tiles equ &1B


JP aff_images
JP init_music

image_high equ 15   ; hauteur de l'image
image_length equ 27 ; largeur de l'image

base_video equ &4004+10 ; Colonne x ligne x

; pointeur pour gerer la table des couleurs des caracteres affiches
; en mode graphique uniquement

ptr_tab_colors defw &0

; Variable pour gerer le mouvement des carres dans les trois lignes de "rasters"

count_change_spr db &0
tab_change_spr defw tab_spr_animation


; Affichage de l'image de la cassette audio
; On prend ceinture et bretelles en sauvegardement systematiquement tous les registres
; principaux.

aff_images
	DI

	PUSH AF
	PUSH BC
	PUSH HL
	PUSH DE
	PUSH IX
	PUSH IY

; Definition des caracteres graphiques

	LD HL,base_tiles
	LD A,32+128
	LD B,94
	CALL init_tiles

	LD HL,colors_datas
	LD (ptr_tab_colors),HL


	LD DE,base_caracteres
	LD HL,base_video

; boucle principale d'affichage

poke_hauteur
	LD B,image_high ; hauteur de l'image

aff_img2
	PUSH BC
	PUSH HL

poke_longueur
	LD B,image_length ; largeur de l'image

aff_img1
	LD A,(DE)
	SET 7,A   ; pour utiliser table de caracteres redefinie


aff_graphic

	LD (HL),A
	INC HL


; on poke pour chaque caractere ses couleurs de fond et d'avant plan
; on est oblige de sauvegarder IX ? Non, mais bon, on teste

	PUSH IX
	LD IX,(ptr_tab_colors)
	LD A,(IX+&0)
	LD (HL),A
	INC IX
	LD (ptr_tab_colors),IX
	POP IX

aff_img3
	INC HL
	INC DE
	DJNZ aff_img1

	POP HL	
	LD BC,80         ; on passe a la ligne suivante
	ADD HL,BC
	POP BC
	DJNZ aff_img2

back_to_basic

	POP IY
	POP IX
	POP DE
	POP HL
	POP BC
	POP AF
	EI
	RET


; initialisation d'une table de caracteres
; graphique ou texte.

init_tiles

init_tiles1
	PUSH BC
	PUSH AF
	PUSH HL
	
	CALL vector_init_tiles
	POP HL
	LD BC,&A
	ADD HL,BC
	POP AF
	INC A
	POP BC
	DJNZ init_tiles1
	RET

; codage des couleurs des caracteres graphiques 

c1 equ 128+64+7 ; fond bleu, texte blanc
c2 equ 128+0+7 ; fond noir, texte blanc
c3 equ 128+0+3 ; fond noir, texte jaune

c4 equ 128+16+0 ; fond magenta, texte noir

c5 equ 128+80+0 ; fond etiquette, texte noir
c6 equ 128+80+7 ; fond etiquette, texte blanc
c7 equ 128+0+6  ; fond noir, texte cyan
c8 equ 128+0+4  ; fond noir, texte bleu
c9 equ 128+80+6 ; fond etiquette, texte cyan

ca equ 128+16+0 ; fond etiquette2, texte noir
cb equ 128+16+7 ; fond etiquette2, texte noir
cc equ 128+16+6 ; fond etiquette2, texte cyan
cd equ 128+64+6 ; fond bleu, texte cyan


; pour chaque caractere graphique affiche, on a dans ce tableau la definition des
; couleurs de fond et d'avant plan

colors_datas

db c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1,c1
db c1,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c1
db c1,c2,c6,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c9,c2,c1
db c1,c2,cb,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,cc,c2,c1
db c1,c2,c6,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c9,c2,c1

db c1,c2,cb,cb,cb,cb,cb,cb,cb,cb,ca,c4,c4,c4,c4,c4,ca,cb,cb,cb,cb,cb,cb,cb,cc,c2,c1
db c1,c2,c6,c6,c6,c6,c6,c6,c6,c6,c5,c4,c4,c4,c4,c4,c5,c6,c6,c6,c6,c6,c6,c6,c9,c2,c1
db c1,c2,cb,cb,cb,cb,cb,cb,cb,cb,ca,c4,c4,c4,c4,c4,ca,cb,cb,cb,cb,cb,cb,cb,cc,c2,c1

db c1,c2,c6,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c5,c9,c2,c1
db c1,c2,cb,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,ca,cc,c2,c1
db c1,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c1

db c1,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c2,c1
db c1,c2,c2,c2,c2,c2,c2,c8,c8,c8,c8,c8,c8,c8,c8,c8,c8,c8,c8,c8,c8,c2,c2,c2,c2,c2,c1
db c1,c2,c2,c2,c2,c2,c2,c8,c8,c8,c8,c8,c8,c8,c8,c8,c8,c8,c8,c8,c8,c2,c2,c2,c2,c2,c1
db c1,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd,cd


; Les caracteres composant la cassette, 15 lignes de 27 octets

base_caracteres

DB &20,&21,&22,&22,&22,&22,&22,&22,&22,&22,&22,&22,&22,&22,&22,&22,&22,&22,&22,&22,&22,&22,&22,&22,&22,&23,&20
DB &24,&25,&26,&26,&26,&26,&26,&26,&26,&26,&26,&26,&26,&26,&26,&26,&26,&26,&26,&26,&26,&26,&26,&26,&26,&27,&28
DB &29,&20,&2A,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&2B,&20,&2A
DB &29,&20,&2A,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&2B,&20,&2A
DB &29,&20,&2A,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&2B,&20,&2A
DB &29,&20,&2A,&20,&20,&20,&2C,&2D,&2E,&2F,&29,&30,&31,&32,&33,&33,&34,&35,&36,&37,&38,&20,&20,&20,&2B,&20,&2A
DB &29,&20,&2A,&20,&20,&20,&39,&3A,&3B,&3C,&29,&3D,&31,&3E,&3F,&3F,&40,&41,&20,&42,&43,&20,&20,&20,&2B,&20,&2A
DB &29,&20,&2A,&20,&20,&20,&44,&45,&46,&47,&48,&49,&31,&4A,&4B,&4B,&4C,&4D,&4E,&4F,&50,&20,&20,&20,&2B,&20,&2A
DB &29,&20,&2A,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&2B,&20,&2A
DB &29,&20,&51,&20,&20,&20,&20,&20,&52,&53,&54,&55,&56,&57,&58,&59,&5A,&5B,&5C,&20,&20,&20,&20,&20,&2B,&20,&2A
DB &29,&20,&5D,&5E,&5E,&5E,&5F,&60,&60,&60,&60,&60,&60,&60,&60,&60,&60,&60,&60,&60,&61,&62,&5E,&5E,&63,&20,&2A
DB &29,&20,&20,&20,&20,&64,&65,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&20,&66,&20,&20,&20,&20,&2A
DB &29,&20,&20,&20,&20,&67,&20,&68,&69,&6A,&6B,&20,&20,&20,&20,&20,&6C,&6D,&20,&68,&69,&6E,&20,&20,&20,&20,&2A
DB &6F,&70,&20,&20,&20,&71,&20,&72,&73,&74,&75,&20,&20,&20,&20,&20,&76,&77,&20,&72,&73,&78,&79,&20,&20,&7A,&7B
DB &20,&7C,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&5E,&7D,&20


; Tiles 32 to 32+93

base_tiles

DB &00,&00,&00,&00,&00,&00,&00,&00,&00,&00
DB &00,&00,&00,&00,&00,&00,&00,&00,&0F,&3F
DB &00,&00,&00,&00,&00,&00,&00,&00,&FF,&FF
DB &00,&00,&00,&00,&00,&00,&00,&00,&E0,&F8
DB &00,&00,&01,&01,&03,&03,&03,&03,&03,&03
DB &70,&C0,&80,&80,&00,&00,&00,&00,&00,&00
DB &00,&00,&00,&00,&00,&00,&00,&00,&00,&FF
DB &1C,&06,&03,&03,&01,&01,&01,&01,&00,&00
DB &00,&00,&00,&00,&80,&80,&80,&80,&80,&80
DB &03,&03,&03,&03,&03,&03,&03,&03,&03,&03
DB &80,&80,&80,&80,&80,&80,&80,&80,&80,&80
DB &01,&01,&01,&01,&01,&01,&01,&01,&01,&01
DB &00,&00,&00,&00,&00,&01,&03,&06,&05,&0D
DB &00,&0F,&38,&67,&DF,&B1,&61,&C1,&E0,&F0
DB &00,&FC,&07,&F9,&FE,&E3,&E0,&E0,&C0,&00
DB &00,&00,&00,&C0,&60,&B0,&D8,&68,&2C,&74
DB &FF,&FF,&FF,&AF,&57,&AB,&57,&AB,&57,&AB
DB &FF,&FF,&FF,&FF,&FF,&FF,&FF,&FF,&FF,&FF
DB &FF,&FF,&FF,&FA,&F5,&FA,&F5,&FA,&F5,&EA
DB &FF,&FF,&FF,&AA,&55,&AA,&55,&AA,&55,&AA
DB &E0,&E0,&E0,&E0,&60,&E0,&60,&E0,&60,&E0
DB &00,&00,&00,&01,&03,&06,&0C,&19,&12,&34
DB &00,&1F,&F0,&8F,&78,&FC,&FC,&78,&30,&00
DB &00,&F0,&1C,&E7,&3B,&1C,&1F,&3F,&1E,&0C
DB &00,&00,&00,&00,&80,&C0,&60,&A0,&F0,&50
DB &0B,&1A,&1A,&1A,&1A,&1A,&1A,&1A,&1B,&0B
DB &F0,&E0,&00,&00,&00,&00,&00,&C0,&C0,&E0
DB &00,&01,&00,&00,&00,&00,&00,&00,&00,&01
DB &F6,&FA,&FA,&4A,&0A,&0A,&0A,&0A,&CA,&FA
DB &55,&AB,&55,&AB,&55,&AB,&55,&AB,&55,&AB
DB &F5,&EA,&F5,&EA,&F5,&EA,&F5,&EA,&F5,&EA
DB &55,&AA,&55,&AA,&55,&AA,&55,&AA,&55,&AA
DB &60,&E0,&60,&E0,&60,&E0,&60,&E0,&60,&E0
DB &24,&68,&5E,&5F,&5F,&5F,&5E,&58,&68,&28
DB &00,&00,&00,&00,&01,&01,&01,&00,&00,&00
DB &58,&28,&2C,&F4,&F4,&F4,&F4,&F4,&28,&68
DB &0D,&05,&06,&03,&01,&00,&00,&00,&00,&00
DB &E0,&C0,&80,&41,&B1,&D9,&67,&18,&07,&00
DB &01,&01,&C0,&E0,&E1,&F6,&F9,&07,&F8,&00
DB &F4,&F4,&E8,&D8,&B0,&60,&C0,&00,&00,&00
DB &03,&03,&03,&03,&03,&03,&03,&03,&03,&01
DB &55,&AB,&55,&AB,&57,&AB,&57,&BF,&FF,&FF
DB &F5,&EA,&F5,&FA,&F5,&FA,&F5,&FF,&FF,&FF
DB &55,&AA,&55,&AA,&55,&AA,&55,&FF,&FF,&FF
DB &60,&E0,&60,&E0,&60,&E0,&60,&E0,&E0,&E0
DB &3C,&14,&1A,&0D,&06,&03,&01,&00,&00,&00
DB &00,&60,&F0,&F0,&F0,&60,&DF,&60,&1F,&00
DB &00,&18,&3D,&3F,&3E,&1D,&F7,&1C,&E0,&00
DB &58,&D0,&B0,&60,&C0,&80,&00,&00,&00,&00
DB &80,&80,&80,&80,&80,&80,&80,&80,&80,&40
DB &00,&00,&1E,&10,&12,&12,&1E,&00,&00,&00
DB &00,&00,&F7,&94,&F7,&84,&84,&00,&00,&00
DB &00,&00,&8E,&89,&8E,&89,&89,&00,&00,&00
DB &00,&00,&39,&42,&62,&42,&39,&00,&00,&00
DB &00,&00,&CC,&12,&12,&12,&CC,&00,&00,&00
DB &00,&00,&E7,&94,&E4,&94,&97,&00,&00,&00
DB &00,&00,&1C,&A0,&98,&84,&38,&00,&00,&00
DB &00,&00,&20,&46,&48,&46,&20,&00,&00,&00
DB &00,&00,&87,&40,&47,&44,&87,&00,&00,&00
DB &00,&00,&BD,&A4,&A5,&25,&BD,&00,&00,&00
DB &00,&00,&EF,&21,&EF,&08,&EF,&00,&00,&00
DB &3F,&00,&00,&00,&00,&00,&00,&00,&00,&00
DB &FF,&00,&00,&00,&00,&00,&00,&00,&00,&00
DB &FF,&00,&00,&00,&00,&00,&00,&1F,&7F,&C0
DB &FF,&00,&00,&00,&00,&00,&00,&FF,&FF,&00
DB &FF,&00,&00,&00,&00,&00,&00,&FE,&FF,&00
DB &FF,&00,&00,&00,&00,&00,&00,&00,&80,&40
DB &FE,&00,&00,&00,&00,&00,&00,&00,&00,&00
DB &00,&00,&01,&01,&01,&01,&01,&02,&02,&02
DB &80,&80,&00,&00,&00,&00,&00,&00,&00,&00
DB &20,&20,&20,&20,&10,&10,&10,&10,&10,&08
DB &02,&02,&04,&04,&04,&04,&04,&08,&08,&08
DB &00,&00,&00,&00,&00,&00,&00,&3F,&7F,&FF
DB &00,&00,&00,&00,&00,&00,&00,&00,&80,&C0
DB &00,&00,&00,&00,&01,&03,&07,&07,&07,&07
DB &00,&00,&00,&00,&F0,&F8,&FC,&FC,&FC,&FC
DB &00,&00,&00,&00,&03,&07,&0F,&0F,&0F,&0F
DB &00,&00,&00,&00,&E0,&F0,&F8,&F8,&F8,&F8
DB &08,&08,&08,&08,&04,&04,&04,&04,&04,&02
DB &03,&03,&03,&03,&03,&03,&01,&00,&00,&00
DB &00,&00,&00,&00,&00,&00,&00,&80,&40,&20
DB &08,&08,&10,&10,&10,&10,&10,&20,&20,&20
DB &FF,&FF,&FF,&FF,&FF,&7F,&3F,&00,&00,&00
DB &C0,&C0,&C0,&C0,&C0,&80,&00,&00,&00,&00
DB &07,&03,&01,&00,&00,&00,&00,&00,&00,&00
DB &FC,&F8,&F0,&00,&00,&00,&00,&00,&00,&00
DB &0F,&07,&03,&00,&00,&00,&00,&00,&00,&00
DB &F8,&F0,&E0,&00,&00,&00,&00,&00,&00,&00
DB &02,&02,&02,&02,&01,&01,&01,&01,&01,&00
DB &00,&00,&00,&00,&00,&00,&00,&00,&00,&80
DB &00,&00,&00,&00,&00,&00,&00,&01,&02,&04
DB &80,&80,&80,&80,&80,&80,&80,&00,&00,&00
DB &1F,&00,&00,&00,&00,&00,&00,&00,&00,&00
DB &F8,&00,&00,&00,&00,&00,&00,&00,&00,&00


; On patche le player Soundtrakker 128 pour etre utilisable avec une interface
; sonore dedie au VG 5000 = VG5232, VG5210 ou VG5292

patch_music
	OUT (&FF),A
	LD A,C
	OUT (&FE),A
	RET

; Quand le RST&38 est appele, la premier chose qu'il fait est d'appeler une routine
; en &47D0. Le programme patche la routine et empeche le VG 5000 de faire quoi que cela
; soit (recopie du buffer video vers l'EF9345 principalement).

no_video
	INC SP
	INC SP
	EI
	RET


; Bon ben la, pas grand chose a dire
; On patche juste le vecteur appele par le RST&30 (RESET avec CONTROL DELTA) pour pouvoir
; stopper a l'arrache le programme sans que des sons disgracieux restent "coinces" dans la puce sonore
; (sons continus).

init_music

	DI
	PUSH AF
	PUSH BC
	PUSH HL
	PUSH DE
	PUSH IX
	PUSH IY

	LD HL,clean_reset
	LD (&47EF),HL

	LD HL,patch_music
	LD DE,&84A5
	LD BC,&6
	LDIR

	XOR A
	LD (count_change_spr),A

	CALL &8000

	LD A,&C3
	LD (&47D0),A
	LD HL,no_video
	LD (&47D1),HL

	EI    ; pas sur que cela serve a quelque chose mais dans le doute...
	HALT

	JP main

; Gestion de la redefinition des caracteres simulant le mouvement des petits carres
; sur les trois lignes du bas de l'interface. On a juste besoin de deux caracteres.
; Heureusement, car la routine systeme est apparement bien lente (envoi de donnees
; a l'EF9345 apres avoir reformate la structure des donnees de caracters envoyees)

gere_line_move

	LD A,(count_change_spr)
	INC A
	LD (count_change_spr),A
	CP 4
	RET NZ
	XOR A
	LD (count_change_spr),A

	LD HL,(tab_change_spr)

gere_line_move1
	LD E,(HL)
	INC HL
	LD D,(HL)
	INC HL

	LD A,D
	AND A
	JR NZ,gere_line_move2
	LD HL,tab_spr_animation
	JR gere_line_move1

gere_line_move2
	EX DE,HL
	PUSH HL
	PUSH DE
	LD A,127+128
	CALL vector_init_tiles
	POP HL
	POP DE
	LD E,(HL)
	INC HL
	LD D,(HL)
	INC HL
	LD (tab_change_spr),HL
	EX DE,HL
	PUSH HL
	PUSH DE
	LD A,126+128
	CALL vector_init_tiles
	POP DE
	POP HL
	RET
	
spr_127_step1 db &00,&00,&00,&77,&77,&77,&00,&00,&00,&00
spr_127_step2 db &00,&00,&00,&EE,&EE,&EE,&00,&00,&00,&00
spr_127_step3 db &00,&00,&00,&DD,&DD,&DD,&00,&00,&00,&00
spr_127_step4 db &00,&00,&00,&BB,&BB,&BB,&00,&00,&00,&00

tab_spr_animation
	defw spr_127_step1,spr_127_step4
	defw spr_127_step2,spr_127_step3
	defw spr_127_step3,spr_127_step2
	defw spr_127_step4,spr_127_step1
	defw &0000,&0000


; On joue la musique, teste la touche espace et redefinit les caracteres
; On met un HALT entre les deux routines pour eviter des artefacts video
; (pas tout compris, mais bon)... Si on en met plus, ca foire aussi.
; En theorie, on a 6 HALT par frame. Le player ST-128 en bouffe une, donc il devrait
; y avoir de la marge, mais non... 
; Hypothese pas verifiee, le temps de redefinition des caracteres est tres long.


main	DI

	PUSH AF
	PUSH BC
	PUSH DE
	PUSH HL
	PUSH IX
	PUSH IY

	CALL &8003

	POP IY
	POP IX
	POP HL
	POP DE
	POP BC
	POP AF
	EI

	HALT

	IN A,(&81)              ; on teste si espace a ete pressee. 
	BIT 2,A
	JP z,stop_music

	DI
	PUSH AF
	PUSH BC
	PUSH DE
	PUSH HL
	PUSH IX
	PUSH IY

	CALL gere_line_move

	POP IY
	POP IX
	POP HL
	POP DE
	POP BC
	POP AF

	EI
	JP main

stop_music
	DI
	LD A,&C9
	LD (&47D0),A

	CALL &8006

	JP back_to_basic


; bon, pas si clean que ca.
; Les interruptions doivent etre activees avant de faire le RST &0
; La carte son peut rester dans un etat un peu etrange (corruption des
; voix si on recharge dans la foulee Tape Leader).
; On rajoute gentiment des HALT des fois que cela soit juste une question
; de temps... Youpi, ca semble fonctionner !

clean_reset

	DI
	LD A,&C9
	LD (&47D0),A
	CALL &8006
	EI
	HALT
	HALT
	RST &0	